﻿if (!QIHelpDesk.grid)
{
	QIHelpDesk.grid = {};
	QIHelpDesk.grid.options = { rootOptions: null, editType: null, dialogID: null, dialog: null, textBox: null, url: null, height: 0, width: 0, left: -1, top: -1, rowNum: 5, caption: '', sortColumn: null, tableElement: null, pagerElement: null, xmlElement: null, rowIDControl: null, returnColumn: null, incrementalSearch: false, searchColumn: '', buttonType: 'link', detailText: 'Detail', editText: 'Upravit', descText: 'Popis', values: { id: null, value: null } };
	QIHelpDesk.grid.urlParams = null;
}

(function ()
{
	var grid = QIHelpDesk.grid;
	grid.__controlId = 0;

	var isInitialized = false;

	if (!($.fn.dataTable))
	{
/*
		$.getScript("//cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js").done(function ()
		{
			$.getScript("//cdn.datatables.net/1.10.20/js/dataTables.bootstrap4.min.js").done(function ()
			{
				QIPortalAPI.loadCSS("//cdn.datatables.net/1.10.20/css/dataTables.bootstrap4.min.css");

				isInitialized = true;
			});
		});
*/
		$.getScript("//cdn.datatables.net/1.10.20/js/jquery.dataTables.js").done(function ()
		{
			$.getScript("//cdn.datatables.net/1.10.20/js/dataTables.bootstrap4.js").done(function ()
			{
				QIPortalAPI.loadCSS("//cdn.datatables.net/1.10.20/css/dataTables.bootstrap4.css");

				isInitialized = true;
			});
		});
	}

	grid.createTicketGrid = function (options, columns)
	{
		if (!isInitialized)
		{
			window.setTimeout(function ()
			{
				grid.createTicketGrid(options, columns);
			}, 100);

			return;
		}

		QIPortal.getUserSettings('HelpDesk.GridParams', null, function (data)
		{
			if (!options)
				options = QIHelpDesk.grid.options;

			options = jQuery.extend(true, {}, options);

			var pData = { act: 'rData' };
			pData.fmt = 'json';
			QIHelpDesk.setRequestParams(pData);

			var cols = [];
			for (var i = 1; i < columns.model.length; i++)
			{
				cols.push({ data: columns.model[i].name.replace('.', '_'), title: columns.names[i] });
			}

			cols.push({
				targets: -1, data: null, render: function(data, type, row, meta)
				{
					if ((QIHelpDesk.urls.editTicket.name === '') || (data.IsEditable === '0'))
						return null;

					return QIHelpDesk.grid.btnEdit(options, null, data);
				}
			});

			cols.push({
				targets: -1, data: null, render: function(data, type, row, meta)
				{
					if ((QIHelpDesk.urls.newTicketDesc.name === '') || (data.CanAddDesc === '0'))
						return null;

					return QIHelpDesk.grid.btnDesc(options, null, data);
				}
			});

			var url = options.url || QIPortalAPI.appPath + 'Modules/QIHelpDesk/dataProviders/Tickets.aspx';

			var jq = jQuery(options.tableElement);
			jq.css('width', '100%');

			var ticketGrid = jq.DataTable({
				serverSide: true,
				language: {
					paginate: {
						previous: "&lt;",
						next: "&gt;"
					}
				},
				info: false,
				//paging: false,
				lengthChange: false,
				ordering: false,
				searching: false,
				processing: false,

				columns: cols,

				ajax: {
					url: url,
					method: "POST",
					data: function (d)
					{
						pData.draw = d.draw;
						pData.page = (d.start / d.length) + 1;
						pData.rows = d.length;

						var rCols = [];
						for (var i = 1; i < columns.model.length; i++)
						{
							rCols.push(columns.model[i].name);
						}
						pData.cols = rCols.join(',');

						return pData;
					},
					cache: false
				}
			});

			jQuery(options.tableElement + ' tbody').on('click', 'tr',
				function ()
				{
					var data = ticketGrid.row(this).data();
					var type = 'ticketDetail';


					let url = window.useShortUrlGlobal
						? QIHelpDesk.urls[type].name + '-' + QIHelpDesk.urls[type].urlid + data.ICU.split("_")[0] 
						: QIHelpDesk.urls[type].name + '-_' + QIHelpDesk.urls[type].urlid + data.ICU + '.aspx';

					location.href = url;
				});


			QIHelpDesk.grid.ticketGrid = ticketGrid;

		});
	};

	grid.refreshTicketGrid = function (urlParams)
	{
	};

	grid.createGrid = function (options, columns)
	{
		if (!isInitialized)
		{
			window.setTimeout(function ()
			{
				ui.createGrid(options, columns);
			}, 100);

			return;
		}

		if (!options)
			options = QIHelpDesk.grid.options;

		var opt = options;
		if (opt.rootOptions)
			opt = opt.rootOptions;
		opt.gridColumns = columns;

		options = jQuery.extend(true, {}, options);
		options.rootOptions = opt;

		var jq = jQuery('#' + options.tableElement);

		var pData = QIHelpDesk.setQueryData(options);
		pData.act = 'rData';
		pData.fmt = 'json';
		QIHelpDesk.setRequestParams(pData);

		if (QIHelpDesk.superiorHasOriginalValue(options))
		{
			pData.orgIDValue = options.orgIDValue;
			pData.orgValue = options.orgValue;
		}

		pData.returnColumn = options.returnColumn;

		var gridData = jq.prop('gridData');
		jq.prop('gridData', pData);
		if (gridData == null)
		{
			jq.css('width', '100%');

			var cols = [];
			for (var i = 1; i < columns.model.length; i++)
			{
				cols.push({ data: columns.model[i].name, title: columns.names[i] });
			}

			var dataGrid = jq.DataTable({
				language: {
					paginate: {
						previous: "&lt;",
						next: "&gt;"
					}
				},
				info: false,
				//paging: false,
				lengthChange: false,
				ordering: false,
				searching: false,
				processing: false,

				autoWidth: false,

				serverSide: true,
				columns: cols,
				ajax: {
					url: options.url,
					method: 'POST',
					data: function(d)
					{
						var p = jq.prop('gridData');
						p.draw = d.draw;
						p.page = (d.start / d.length) + 1;
						p.rows = d.length;

						return p;
					},
					cache: false
				}
			});

			jQuery('#' + options.tableElement + ' tbody').on('click',
				'tr',
				function()
				{
					var data = dataGrid.row(this).data();
					QIHelpDesk.grid.onRowDblClick(options, data);
					//debugger;
				});
		}
		else
		{
			var dataGrid = jq.DataTable();
			dataGrid.draw();
		}

		window.setTimeout(function ()
		{
			options.dialog.css('width', '100%');
			options.dialog.parent().find(".ui-dialog-titlebar").removeClass('ui-widget-header');
		}, 50);
	};

	QIHelpDesk.grid.getGridPostData = function (options)
	{
		return jQuery('#' + options.tableElement).prop('gridData');
/*
		if (!$.fn.dataTable.isDataTable('#' + options.tableElement))
			return null;

		var settings = jQuery('#' + options.tableElement).dataTable().fnSettings();
		if (settings.ajax == null)
			return null;

		return settings.ajax.data;
*/
	}

	grid.search = function (options)
	{
		if ((!options) || (!options.tableElement) || (!$.fn.dataTable.isDataTable('#' + options.tableElement)))
			return;

		var jq = jQuery('#' + options.tableElement);
		var pData = jq.prop('gridData');
		if (!pData)
			return;

		var srchCol = options.searchColumn;
		var srchVal = jQuery('#' + options.dialogID + '_search').val();

		if (options.gridColumns)
		{
			srchCol = '';
			for (var i = 0; i < options.gridColumns.model.length; i++)
			{
				var model = options.gridColumns.model[i];
				if (model.hidden)
					continue;

				var name = model.name;
				if (name.toLowerCase() === 'icu')
					continue;

				srchCol += ',' + name;
			}
		}

		if ((pData.searchField === srchCol) && (pData.searchString === srchVal))
			return;

		pData.searchField = srchCol;

		pData.searchOper = 'eq';
		pData.searchString = srchVal;

		jq.DataTable().draw();
	};

})();